# Contributing Guidelines

## Code of Conduct

In order to participate your behavior must conform to our [code of conduct](https://github.com/andrewgjohnson/imagettftextblur/blob/master/CODE_OF_CONDUCT.md).

## Submitting Changes

Please send a [GitHub Pull Request](https://github.com/andrewgjohnson/imagettftextblur/pull/new/master) with a clear list of what you've done (read more about [pull requests](https://help.github.com/articles/about-pull-requests/)).  We can always use more test coverage.  Please follow our coding conventions (below) and make sure all of your commits are atomic (one feature per commit).  Please use our [pull request template](https://github.com/andrewgjohnson/imagettftextblur/blob/master/PULL_REQUEST_TEMPLATE.md) when submitting pull requests.

Always write a clear log message for your commits.  One-line messages are fine for small changes, but bigger changes should look like this:

    $ git commit -m "A brief summary of the commit
    >
    > A paragraph describing what changed and its impact."

## Coding Conventions

We follow the [PSR-1](http://www.php-fig.org/psr/psr-1/) & [PSR-2](http://www.php-fig.org/psr/psr-2/) standards and will require your changes to as well.  PSR-1 & PSR-2 intentionally avoid any recommendation regarding the use of `$StudlyCaps`, `$camelCase`, or `$under_score` so please be consistent with what already exists.
